#version 120
varying vec2 texCoord;

uniform sampler2D colorMap;
uniform sampler2D torusMap;



void main (void)
{
    vec4 pixel;
    vec4 accum;
    pixel=texture2D(torusMap, texCoord);
    float i1=-30;
    float i2=30;
    float a1=15;

    for (float i=i1;i<i2;i+=4.0){
        for (float j=i1;j<i2;j+=4.0){
            vec2 offset=vec2(clamp(texCoord.x+i*1.0f/1920.0f,0.0,1.0-2.0/1920.0),clamp(texCoord.y+j*1.0f/1080.0f,0.0,1.0-2.0/1080.0));
            offset.x=clamp(offset.x,0.0f,1.0f);
            offset.y=clamp(offset.y,0.0f,1.0f);
            accum+=texture2D(torusMap, offset);
        }
    }
    accum/=a1*a1*1.2;
    vec4 pixel2=texture2D(torusMap, texCoord);
    if (pixel2==vec4(0,0,0,1)) pixel2=texture2D(colorMap, texCoord);

    




	
	gl_FragColor = accum+pixel2;

	
	
}
